﻿!include "MUI2.nsh"
!include "LogicLib.nsh"
;!include WinMessages.nsh


!define ORG "ALL"
!define VERSION "${ORG} 0.0.4u"
!define NAME "ComMerge v. ${VERSION}"
!define FILENAME "com_merge.dot"
!define EXTEMPLATE "pripominky.xls"
!define DESC "Doplněk pro sběr připomínek z komentářů."
            
Name "${NAME}"


!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP ".\Contrib\Graphics\Header\orange.bmp" ; optional
!define MUI_ICON ".\Contrib\Graphics\Icons\orange-install.ico"


!define MUI_WELCOMEPAGE_TITLE "Vitá vás instalační program"
!define MUI_WELCOMEPAGE_TEXT "Vítejte v instalačním programu ${NAME}, který vás provede instalací tohoto produktu."
!define MUI_WELCOMEFINISHPAGE_BITMAP ".\Contrib\Graphics\Wizard\arrow.bmp" 


;--------------------------------
;Pages
;--------------------------------
!insertmacro MUI_PAGE_WELCOME
;!insertmacro MUI_PAGE_DIRECTORY
;Page Custom LockedListShow
!insertmacro MUI_PAGE_INSTFILES
  

;--------------------------------
;Langs
!insertmacro MUI_LANGUAGE "Czech"
;--------------------------------

; The file to write
OutFile "ComMerge_${VERSION}.exe"
InstallDir $DOCUMENTS

; Request application privileges for Windows Vista
 RequestExecutionLevel user
; RequestExecutionLevel admin

Function .onInit
  ${If} ${Silent}
 ;     ReadRegStr $R0 HKCU \
 ;     "Software\Microsoft\Windows\CurrentVersion\Uninstall\${NAME}" \
 ;     "UninstallString"
 ;     StrCmp $R0 "" notRunning
 ;     Exec "$R0 /S"
      Goto notRunning
  ${EndIf}
  FindWindow $0 "OpusApp"
  StrCmp $0 0 notRunning
    MessageBox MB_OKCANCEL "Zdá se, že aplikace MS Word je právě spuštěna. Při pokračování instalace bude MS Word ukončen. Před ukončením uložte prosím otevřené dokumenty. Přejete si pokračovat?" IDOK OK IDCANCEL CANCEL
    OK:
      SendMessage $0 ${WM_CLOSE} 0 0
      FindWindow $0 "OpusApp"
      IntCmp $0 0 notRunning

      ;Odinstalace
      ReadRegStr $R0 HKCU \
      "Software\Microsoft\Windows\CurrentVersion\Uninstall\${NAME}" \
      "UninstallString"
      StrCmp $R0 "" notRunning
      Exec $R0

      Goto OK
    CANCEL:
      Abort
 
notRunning:
  ; Determine office version
  Gval: ReadRegStr $1 HKLM "Software\Microsoft\Office\$0.0\Word\InstallRoot\" "Path"
  Processes::KillProcess "winword.exe"
                       
${If} $0 <= 16
 ${If} $1 == ""
 IntOp $0 $0 + 1
   Goto Gval
 ${EndIf}

${Else}
  MessageBox MB_OK "Zdá se, že nemáte nainstalovánu aplikaci Microsoft Word."
  Abort

${EndIf}



;  StrCpy $1 "$1Library\"
 ReadRegStr $9 HKCU "Software\Microsoft\Office\$0.0\Common\General" "Startup"
 StrCpy $INSTDIR "$APPDATA\Microsoft\Word\$9"
 StrCpy $8 $INSTDIR
; StrCpy $INSTDIR $1
FunctionEnd

Section ""
  StrCpy $2 "$INSTDIR\${FILENAME}"

; Write to registry
WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\${NAME}" \
                 "DisplayName" "${NAME}"
WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\${NAME}" \
                 "UninstallString" "$\"$INSTDIR\UninstallComMerge.exe$\""
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${NAME}" \
                 "QuietUninstallString" "$\"$INSTDIR\UninstallComMerge.exe$\" /S"
                 
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${NAME}" \
                 "DisplayIcon" "$\"$INSTDIR\UninstallComMerge.exe$\""
; WriteRegStr HKCU "Software\Microsoft\Office\$0.0\Word\Options\" "OPEN" '"$2"'
; Deploy file
  SetOutPath $INSTDIR
  File ${FILENAME}
  SetOutPath "$APPDATA\MFCR\"
  File ${EXTEMPLATE}
  WriteUninstaller $INSTDIR\UninstallComMerge.exe

SectionEnd

Section "Uninstall"
  DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\${NAME}"
  Delete $INSTDIR\UninstallComMerge.exe
  Delete $APPDATA\MFCR\${EXTEMPLATE}
  Delete "$INSTDIR\${FILENAME}"
SectionEnd
